<?PHP
/**
* @package direct-project-innovation-initiative
* @subpackage views
* @filesource
*/ /** */

$CI = get_instance(); //the controller is not always available as $this, so we'll grab the controller via get_instance() instead

$show_adminpanel_link = $CI->has_permission('adminpanel');

//get group mailboxes
$group_mailboxes = $CI->session->userdata('group_mailboxes');
if(!$CI->session->userdata('hide_personal_mailbox')) { $group_mailboxes[$CI->session->userdata('username')] = 'Personal (' . htmlentities($CI->session->userdata('username')). ')'; }
?>

<div id="logout">
	<div class="optionbar_left">
		<div id="optionbar_menu">
			<?PHP 
				echo '<span style="float: left; padding-right: 10px;"><a tabindex="1" class="hidden_context hidden_link" id="skipNav" href="#menuContent">Skip Navigation</a></span>';
				//mailbox link
				if(!string_contains('/inbox', current_url())) {
					echo '<span class="optionbar_menu_item"><a href="' .  site_url('inbox') . '">Mailbox</a></span>';
				}
				else {  echo '<span class="selected optionbar_menu_item">Mailbox</span>'; }
				
				//settings link
				if(!string_contains('settings', current_url())) { echo '<span class="optionbar_menu_item"><a href="' . site_url('settings') . '">Settings</a></span>'; }
				else { echo '<span class="selected optionbar_menu_item">Settings</span>'; }
				
				//feedback link
				echo '<span class="optionbar_menu_item"><a href="javascript:provideFeedback();">Feedback</a></span>';
				
				//reports link
				if(strpos($_SERVER['REQUEST_URI'],'reports') === FALSE || strpos($_SERVER['REQUEST_URI'],'adminpanel') !== FALSE) {
					echo '<span class="optionbar_menu_item"><a href="' .  base_url() .'reports/get_mailbox_activities">Reports</a></span>';
				}
				else { echo '<span class="selected optionbar_menu_item">Reports</span>'; }
				
				//Show Global Address book and personal address book on any inbox controller only

				echo '<span class="optionbar_menu_item"><a href="javascript:getGlobalAddressBook();">Global Address Book</a></span>';
				echo '<span class="optionbar_menu_item"><a href="javascript:getPersonalAddressBook();">Personal Contacts List</a></span>';

				
				//admin panel link
				if($show_adminpanel_link) {
					if(strpos($_SERVER['REQUEST_URI'],'adminpanel') === FALSE) {
						echo '<span class="optionbar_menu_item"><a href="/adminpanel">Admin Panel</a></span>';
					}
					else { echo '<span class="selected optionbar_menu_item">Admin Panel</span>'; }
				}
			?>
		</div>
	</div>
	<div class="optionbar_right">
	<?PHP
		if(!empty(trim($CI->session->userdata('mailbox_group')))) {
			 //only display group list if the user is in more than one group (i.e. hidden personal mailbox and in at least 2 groups, or visible personal mailbox and in at least one group)
			if(count($group_mailboxes) > 1) {
				echo '<div style="padding-right: 10px; display: inline-block;">';
				echo '<span style="padding-right: 10px; position: relative; top: -5px;">Mailbox Group:</span>';
				$cn = $CI->session->userdata('mailbox_group_cn');
				if(!empty($cn)) { 
					echo '<div class="mailbox_select toplevel"><a href="#">' .
					'<span class="mailbox_name" title="'.htmlentities($cn).'">'. htmlentities($cn) . '</span>';
				} 
				else {
					echo '<div class="mailbox_select toplevel"><a href="#">' . 
					'<span class="mailbox_name" title="'.htmlentities($CI->session->userdata('mailbox_group')).'">'. htmlentities($CI->session->userdata('mailbox_group')). '</span>';
				}
			
				echo '<span class="mailbox_select_icon">&#9660;</span></a>';
				echo '<div class="mailbox_select list">';
					echo '<ul>';
					foreach($group_mailboxes as $group => $group_cn) {
						echo '<li><a href="/inbox/change_mailbox_group/' . rawurlencode($group) . '/">' . htmlentities($group_cn) . '</a></li>';
					}
					echo '</ul>'; 
				echo '</div>';
				echo '</div></div>';
				
			}
		}
	?>
	<span style="float: right;">Logged in as <strong>
	<?PHP
		$cn = $CI->session->userdata("user_cn");
		if(isset($cn) && strlen($cn) > 0) { 
			echo htmlentities($cn); 
		} 
		else { echo htmlentities($CI->session->userdata("username")); }
		echo "</strong> | <a href=\"" . base_url() . "auth/logout" . "\">Logout</a>";
	?>
	</span>
	</div>
</div>

<a id="permission_url" href="" style="display: none;"></a>


